//
//  GeneralTermsAndConditionsViewController.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 28.06.23.
//

import Foundation
import UIKit

class GeneralTermsAndConditionsViewController : UIViewController {
    
    @IBOutlet var dataProtectionView: UIView!
    
    
    @IBOutlet var dataProtectionScrollView: UIView!
    
    @IBOutlet var agbHeaderLabel: UILabel!
    
    @IBOutlet var textFontSizeSlider: UISlider!
    
    
    /*General Conditions*/
    @IBOutlet var generalConditionsHeaderLabel: UILabel!
    
    @IBOutlet var generalConditionsDetailsLabel: UILabel!
    
    var textArray_generalConditionsDetailsLabel = [String]()
    var fontArray_generalConditionsDetailsLabel = [UIFont]()
    var colorArray_generalConditionsDetailsLabel = [UIColor]()
    
    /*Data Protection*/
    @IBOutlet var dataProtectionHeaderLabel: UILabel!
    
    @IBOutlet var dataProtectionDetailsLabel: UILabel!
    
    var textArray_dataProtectionDetailsLabel = [String]()
    var fontArray_dataProtectionDetailsLabel = [UIFont]()
    var colorArray_dataProtectionDetailsLabel = [UIColor]()
    
    
    /*Accessibility*/
    @IBOutlet var accessHeaderLabel: UILabel!
    
    @IBOutlet var accessDetailsLabel: UILabel!
    
    var textArray_accessDetailsLabel = [String]()
    var fontArray_accessDetailsLabel = [UIFont]()
    var colorArray_accessDetailsLabel = [UIColor]()
    
    
    /*Responsibility*/
    @IBOutlet var responsibilityHeaderLabel: UILabel!
    
    @IBOutlet var responsibilityDetailsLabel: UILabel!
    
    var textArray_responsibilityDetailsLabel = [String]()
    var fontArray_responsibilityDetailsLabel = [UIFont]()
    var colorArray_responsibilityDetailsLabel = [UIColor]()

    
    /*Final Words*/
    @IBOutlet var finalWordsHeaderLabel: UILabel!
    
    @IBOutlet var finalWordsDetailsLabel: UILabel!
    
    var textArray_finalWordsDetailsLabel = [String]()
    var fontArray_finalWordsDetailsLabel = [UIFont]()
    var colorArray_finalWordsDetailsLabel = [UIColor]()
 
    
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        textFontSizeSlider.minimumValue = 0.5
        
        textFontSizeSlider.minimumValueImage = UIImage(named: "A_FontSmall")
        textFontSizeSlider.maximumValueImage = UIImage(named: "A_FontBig")
        
        agbHeaderLabel.text = "Allgemeine Geschäftsbedingungen (AGB)"
        agbHeaderLabel.font = Fonts.heavyFontWithSize(size: 15)
        
        
        /*General Conditions*/
        generalConditionsHeaderLabel.text = "Allgemeines"
        generalConditionsHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_generalConditionsDetailsLabel.append("Die Mobile Security Group der Ruhr-Universität Bochum stellt dem/der Nutzer:in mit der HCS Studies App eine kostenlose Anwendung zur freiwilligen Teilnahme an Studien zur Verfügung.\nUnsere Leistungen umfassen daher die Teilnahme an Studien und Umfragen in der allgemeinen deutschen Bevölkerung.")
        
        fontArray_generalConditionsDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_generalConditionsDetailsLabel.append(Colors.greyColor)
        
        self.generalConditionsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_generalConditionsDetailsLabel, arrayColors: colorArray_generalConditionsDetailsLabel, arrayFonts: fontArray_generalConditionsDetailsLabel)
        
        
        /*Data Protection*/
        dataProtectionHeaderLabel.text = "Datenschutz"
        dataProtectionHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_dataProtectionDetailsLabel.append("Um die HCS Studies App uneingeschränkt nutzen zu können, ist Ihre Zustimmung zur Verwendung Ihrer Daten erforderlich.\nMehr zum Thema Datenverarbeitung, Datenspeicherung und Datennutzung finden Sie in unserer Datenschutzerklärung.\nMit dem Akzeptieren dieser AGB stimmen Sie zudem unserer")
        textArray_dataProtectionDetailsLabel.append("Datenschutzerklärung")
        textArray_dataProtectionDetailsLabel.append("zu.")
        
        fontArray_dataProtectionDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_dataProtectionDetailsLabel.append(Fonts.lightFontWithSize(size: 13))
        fontArray_dataProtectionDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_dataProtectionDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionDetailsLabel.append(Colors.carmine)
        colorArray_dataProtectionDetailsLabel.append(Colors.greyColor)
        
        self.dataProtectionDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataProtectionDetailsLabel, arrayColors: colorArray_dataProtectionDetailsLabel, arrayFonts: fontArray_dataProtectionDetailsLabel)
        self.dataProtectionDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_dataProtectionDetailsLabel = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_dataProtectionDetailsLabel(_ :)))
        tapgesture_dataProtectionDetailsLabel.numberOfTapsRequired = 1
        self.dataProtectionDetailsLabel.addGestureRecognizer(tapgesture_dataProtectionDetailsLabel)
        
        
        /*Accessibility*/
        accessHeaderLabel.text = "Zugang und Verfügbarkeit"
        accessHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_accessDetailsLabel.append("Für die vollumfängliche Nutzung der App ist, abhängig von den angebotenen Studien, zusätzlich ein Computer notwendig. Dies gilt jedoch nur für einen Teil des Studienangebotes.")
        
        fontArray_accessDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_accessDetailsLabel.append(Colors.greyColor)
        
        self.accessDetailsLabel.attributedText = getAttributedString(arrayText: textArray_accessDetailsLabel, arrayColors: colorArray_accessDetailsLabel, arrayFonts: fontArray_accessDetailsLabel)
        
        
        /*Responsibility*/
        responsibilityHeaderLabel.text = "Haftung"
        responsibilityHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_responsibilityDetailsLabel.append("Ansprüche des/ der Nutzer:in auf Schadensersatz sind ausgeschlossen.")
        
        fontArray_responsibilityDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_responsibilityDetailsLabel.append(Colors.greyColor)
        
        self.responsibilityDetailsLabel.attributedText = getAttributedString(arrayText: textArray_responsibilityDetailsLabel, arrayColors: colorArray_responsibilityDetailsLabel, arrayFonts: fontArray_responsibilityDetailsLabel)
        

        /*Final Words*/
        finalWordsHeaderLabel.text = "Änderung der Geschäftsbedingungen"
        finalWordsHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_finalWordsDetailsLabel.append("Wir behalten uns vor, diese Geschäftsbedingungen zu ändern. Bei Änderungen an den AGBs werden Sie erneut in dieser App informiert und um Ihre Zustimmung gebeten.")
        textArray_finalWordsDetailsLabel.append("\n\n   Stand: Juni 2023")
        
        
        fontArray_finalWordsDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_finalWordsDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        
        colorArray_finalWordsDetailsLabel.append(Colors.greyColor)
        colorArray_finalWordsDetailsLabel.append(.black)
        
        self.finalWordsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_finalWordsDetailsLabel, arrayColors: colorArray_finalWordsDetailsLabel, arrayFonts: fontArray_finalWordsDetailsLabel)
        self.finalWordsDetailsLabel.isUserInteractionEnabled = true
                
        
        
        // Füge einen Aktionshandler hinzu, um die Schriftgröße des Labels zu ändern
        textFontSizeSlider.addTarget(self, action: #selector(sliderValueChanged(_:)), for: .valueChanged)
    }
    
    // Methode zur Änderung der Schriftgröße
    @objc func sliderValueChanged(_ sender: UISlider) {
        
        // Berechne die neue Schriftgröße basierend auf dem Slider-Wert
        let fontSize = CGFloat(sender.value)
        print("Font Size:")
        print(fontSize)
        
        agbHeaderLabel.font = UIFont.boldSystemFont(ofSize: fontSize*20+2)
        agbHeaderLabel.setNeedsLayout()
        agbHeaderLabel.layoutIfNeeded()
        
        /*General Conditions*/
        generalConditionsHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        generalConditionsHeaderLabel.setNeedsLayout()
        generalConditionsHeaderLabel.layoutIfNeeded()
        
        var fontArray_generalConditionsDetailsLabel = [UIFont]()
        fontArray_generalConditionsDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.generalConditionsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_generalConditionsDetailsLabel, arrayColors: colorArray_generalConditionsDetailsLabel, arrayFonts: fontArray_generalConditionsDetailsLabel)
        generalConditionsDetailsLabel.setNeedsLayout()
        generalConditionsDetailsLabel.layoutIfNeeded()
        
        
        /*Data Protection*/
        dataProtectionHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        dataProtectionHeaderLabel.setNeedsLayout()
        dataProtectionHeaderLabel.layoutIfNeeded()
        
        var fontArray_dataProtectionDetailsLabel = [UIFont]()
        fontArray_dataProtectionDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_dataProtectionDetailsLabel.append(Fonts.lightFontWithSize(size: fontSize*20))
        fontArray_dataProtectionDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        colorArray_dataProtectionDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionDetailsLabel.append(Colors.carmine)
        colorArray_dataProtectionDetailsLabel.append(Colors.greyColor)
        
        self.dataProtectionDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataProtectionDetailsLabel, arrayColors: colorArray_dataProtectionDetailsLabel, arrayFonts: fontArray_dataProtectionDetailsLabel)
        self.dataProtectionDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_dataProtectionDetailsLabel = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_dataProtectionDetailsLabel(_ :)))
        tapgesture_dataProtectionDetailsLabel.numberOfTapsRequired = 1
        self.dataProtectionDetailsLabel.addGestureRecognizer(tapgesture_dataProtectionDetailsLabel)
        
        
        /*Accessibility*/
        accessHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        accessHeaderLabel.setNeedsLayout()
        accessHeaderLabel.layoutIfNeeded()
        
        var fontArray_accessDetailsLabel = [UIFont]()
        fontArray_accessDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.accessDetailsLabel.attributedText = getAttributedString(arrayText: textArray_accessDetailsLabel, arrayColors: colorArray_accessDetailsLabel, arrayFonts: fontArray_accessDetailsLabel)
        accessDetailsLabel.setNeedsLayout()
        accessDetailsLabel.layoutIfNeeded()
        
        /*Responsibility*/
        responsibilityHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        responsibilityHeaderLabel.setNeedsLayout()
        responsibilityHeaderLabel.layoutIfNeeded()
        
        var fontArray_responsibilityDetailsLabel = [UIFont]()
        fontArray_responsibilityDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.responsibilityDetailsLabel.attributedText = getAttributedString(arrayText: textArray_responsibilityDetailsLabel, arrayColors: colorArray_responsibilityDetailsLabel, arrayFonts: fontArray_responsibilityDetailsLabel)
        responsibilityDetailsLabel.setNeedsLayout()
        responsibilityDetailsLabel.layoutIfNeeded()
        

        /*Final Words*/
        finalWordsHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        finalWordsHeaderLabel.setNeedsLayout()
        finalWordsHeaderLabel.layoutIfNeeded()
        
        var fontArray_finalWordsDetailsLabel = [UIFont]()
        fontArray_finalWordsDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_finalWordsDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        
        self.finalWordsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_finalWordsDetailsLabel, arrayColors: colorArray_finalWordsDetailsLabel, arrayFonts: fontArray_finalWordsDetailsLabel)
        self.finalWordsDetailsLabel.isUserInteractionEnabled = true
        finalWordsDetailsLabel.setNeedsLayout()
        finalWordsDetailsLabel.layoutIfNeeded()
    }
    
    
    @objc func tappedOnLabel_dataProtectionDetailsLabel(_ gesture: UITapGestureRecognizer) {
        guard let text = self.dataProtectionDetailsLabel.text else { return }
        let conditionsRange = (text as NSString).range(of: "Datenschutzerklärung")
        
        if gesture.didTapAttributedTextInLabel(label: self.dataProtectionDetailsLabel, inRange: conditionsRange) {
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let navigationController = storyboard.instantiateViewController(withIdentifier: "DataProtectionInformationNC") as! UINavigationController
            
            navigationController.modalPresentationStyle = .popover
            //navigationBarController.modalTransitionStyle = .crossDissolve
                
            present(navigationController, animated: true)
        }
    }

    
    //MARK:- getAttributedString
    func getAttributedString(arrayText:[String]?, arrayColors:[UIColor]?, arrayFonts:[UIFont]?) -> NSMutableAttributedString {
        
        
        
        let finalAttributedString = NSMutableAttributedString()
        
        for i in 0 ..< (arrayText?.count)! {
            
            var attributes = [NSAttributedString.Key.foregroundColor: arrayColors?[i], NSAttributedString.Key.font: arrayFonts?[i]]
            let attributedStr = (NSAttributedString.init(string: arrayText?[i] ?? "", attributes: attributes as [NSAttributedString.Key : Any]))
            
            if i != 0 {
                
                finalAttributedString.append(NSAttributedString.init(string: " "))
            }
            
            finalAttributedString.append(attributedStr)
        }
        
        return finalAttributedString
    }


struct Colors {
    
    static let carmine = UIColor.init(red: 169.0/255.0, green: 1.0/255.0, blue: 25.0/255.0, alpha: 1.0)
    
    static let greyColor = UIColor.init(red: 108.0/255.0, green: 108.0/255.0, blue: 108.0/255.0, alpha: 1.0)
    
    static let black = UIColor.init(red: 0/255.0, green: 0/255.0, blue: 0/255.0, alpha: 1.0)
}
struct Fonts {
    
    static func heavyFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Heavy", size: size)!
    }
    
    static func mediumFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Medium", size: size)!
    }
    
    static func lightFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Light", size: size)!
    }
}

    
    // set background color with gradient
    // https://stackoverflow.com/questions/24380535/how-to-apply-gradient-to-background-view-of-ios-swift-app
    func setGradientBackground() {
        let colorTop =  UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0).cgColor
        let  colorBottom = UIColor(red: 67.0/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0).cgColor
                    
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = [colorTop, colorBottom]
        gradientLayer.locations = [0.0, 1.0]
        gradientLayer.frame = self.view.bounds
                
        self.view.layer.insertSublayer(gradientLayer, at:0)
    }
    
    @IBAction func backButton(_ sender: Any) {
            
        /*
        let appDelegate = UIApplication.shared.delegate as! AppDelegate

        if(!appDelegate.hasAlreadyLaunched){
            let storyBoard: UIStoryboard = UIStoryboard(name: "Main", bundle: nil)
            let vc = storyBoard.instantiateViewController(withIdentifier: "LicenseAgreementVC") as! LicenseAgreementViewController
            self.view.window?.rootViewController = vc
            self.view.window?.makeKeyAndVisible()
            
        }
        */
        let defaults = UserDefaults.standard
        
        if(defaults.object(forKey: "showLicenseAgreement_v0") != nil)
        {
            showLicenseAgreementPublic = defaults.bool(forKey: "showLicenseAgreement_v0")
            if(showLicenseAgreementPublic) {
                let storyBoard: UIStoryboard = UIStoryboard(name: "Main", bundle: nil)
                let vc = storyBoard.instantiateViewController(withIdentifier: "LicenseAgreementVC") as! LicenseAgreementViewController
                self.view.window?.rootViewController = vc
                self.view.window?.makeKeyAndVisible()
            } else if(dataProtectionCalledFromHomeVCPublic) {
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController
                
                self.view.window?.rootViewController = tabBarController
                self.view.window?.makeKeyAndVisible()
            } else {
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
                
                let layout = UICollectionViewFlowLayout()
                self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
                
                self.view.window?.rootViewController = vc
                self.view.window?.makeKeyAndVisible()
            }
            
        } else {
            if(dataProtectionCalledFromHomeVCPublic) {
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController
                
                self.view.window?.rootViewController = tabBarController
                self.view.window?.makeKeyAndVisible()
            } else {
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
                
                let layout = UICollectionViewFlowLayout()
                self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
                
                self.view.window?.rootViewController = vc
                self.view.window?.makeKeyAndVisible()
            }

        }
    }
}
